/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.inventory;

import com.almostreliable.summoningrituals.altar.AltarEntity;
import com.almostreliable.summoningrituals.inventory.AltarInvWrapper;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.component.IngredientStack;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class AltarInventory
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final AltarEntity parent;
    private final AltarInvWrapper vanillaInv;
    private final Deque<Tuple<ItemStack, Integer>> insertOrder;
    private List<ItemStack> items;
    private ItemStack catalyst;

    public AltarInventory(AltarEntity parent) {
        this.parent = parent;
        this.vanillaInv = new AltarInvWrapper(this);
        this.items = new ArrayList<ItemStack>();
        this.catalyst = ItemStack.f_41583_;
        this.insertOrder = new ArrayDeque<Tuple<ItemStack, Integer>>();
    }

    public CompoundTag serializeNBT() {
        ListTag insertList = new ListTag();
        for (Tuple<ItemStack, Integer> insert : this.insertOrder) {
            CompoundTag insertTag = new CompoundTag();
            ((ItemStack)insert.m_14418_()).m_41739_(insertTag);
            insertTag.m_128405_("slot", ((Integer)insert.m_14419_()).intValue());
            insertList.add((Object)insertTag);
        }
        ListTag itemList = new ListTag();
        for (int slot = 0; slot < this.items.size(); ++slot) {
            if (this.items.get(slot).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("slot", slot);
            this.items.get(slot).m_41739_(itemTag);
            itemList.add((Object)itemTag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("insert_order", (Tag)insertList);
        tag.m_128405_("size", this.items.size());
        tag.m_128365_("items", (Tag)itemList);
        tag.m_128365_("catalyst", (Tag)this.catalyst.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag insertList = tag.m_128437_("insert_order", 10);
        this.insertOrder.clear();
        for (Tag insertTag : insertList) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)insertTag));
            this.insertOrder.add((Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)((CompoundTag)insertTag).m_128451_("slot")));
        }
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < tag.m_128451_("size"); ++i) {
            this.items.add(ItemStack.f_41583_);
        }
        ListTag itemList = tag.m_128437_("items", 10);
        for (Tag itemTag : itemList) {
            int slot = ((CompoundTag)itemTag).m_128451_("slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag)));
        }
        this.catalyst = ItemStack.m_41712_((CompoundTag)tag.m_128469_("catalyst"));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlot(slot);
        if (slot == this.items.size()) {
            this.setCatalyst(stack);
            return;
        }
        this.items.set(slot, stack);
        this.onContentsChanged();
    }

    public ItemStack handleInsertion(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remaining = stack;
        for (int i = 0; i < this.items.size(); ++i) {
            if ((remaining = this.insertItem(i, remaining)).m_41619_()) {
                this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)i));
                return ItemStack.f_41583_;
            }
            if (remaining.m_41613_() == stack.m_41613_()) continue;
            stack.m_41774_(remaining.m_41613_());
            this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)stack.m_41777_(), (Object)i));
            return remaining;
        }
        this.items.add(stack);
        this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)stack.m_41777_(), (Object)(this.items.size() - 1)));
        this.onContentsChanged();
        return ItemStack.f_41583_;
    }

    public void popLastInserted() {
        assert (this.parent.m_58904_() != null && !this.parent.m_58904_().f_46443_);
        if (!this.catalyst.m_41619_()) {
            GameUtils.dropItem(this.parent.m_58904_(), this.parent.m_58899_(), this.catalyst, true);
            this.catalyst = ItemStack.f_41583_;
            this.onContentsChanged();
            return;
        }
        if (this.insertOrder.isEmpty()) {
            return;
        }
        Tuple<ItemStack, Integer> last = this.insertOrder.pop();
        ItemStack stack = (ItemStack)last.m_14418_();
        int slot = (Integer)last.m_14419_();
        this.items.get(slot).m_41774_(stack.m_41613_());
        if (this.items.get(slot).m_41619_()) {
            this.trimInventory();
        }
        this.onContentsChanged();
        GameUtils.dropItem(this.parent.m_58904_(), this.parent.m_58899_(), stack, true);
    }

    public void dropContents() {
        Level level = this.parent.m_58904_();
        assert (level != null && !level.f_46443_);
        BlockPos pos = this.parent.m_58899_();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            GameUtils.dropItem(level, pos, stack, false);
        }
        if (!this.catalyst.m_41619_()) {
            GameUtils.dropItem(level, pos, this.catalyst, false);
        }
    }

    public boolean handleRecipe(AltarRecipe recipe) {
        ArrayList<ItemStack> oldItems = new ArrayList<ItemStack>(this.items);
        int toRemove = 0;
        int removed = 0;
        for (IngredientStack input : recipe.getInputs()) {
            toRemove += input.count();
            int inputRemoved = 0;
            for (ItemStack stack : this.items) {
                if (stack.m_41619_() || !input.ingredient().test(stack)) continue;
                int shrinkCount = Math.min(input.count() - inputRemoved, stack.m_41613_());
                stack.m_41774_(shrinkCount);
                if ((inputRemoved += shrinkCount) < input.count()) continue;
                break;
            }
            removed += inputRemoved;
        }
        if (removed < toRemove) {
            this.items = oldItems;
            return false;
        }
        this.catalyst = ItemStack.f_41583_;
        this.rebuildInsertOrder();
        this.onContentsChanged();
        return true;
    }

    private ItemStack insertItem(int slot, ItemStack stack) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlot(slot);
        ItemStack current = this.items.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!current.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current)) {
                return stack;
            }
            limit -= current.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (current.m_41619_()) {
            this.items.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
        } else {
            current.m_41769_(reachedLimit ? limit : stack.m_41613_());
        }
        this.onContentsChanged();
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    private void rebuildInsertOrder() {
        this.insertOrder.clear();
        this.trimInventory();
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.insertOrder.add((Tuple<ItemStack, Integer>)new Tuple((Object)this.items.get(i).m_41777_(), (Object)i));
        }
    }

    private void trimInventory() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (!this.items.get(i).m_41619_()) continue;
            this.items.remove(i);
        }
    }

    private void onContentsChanged() {
        this.parent.m_6596_();
        if (this.parent.m_58904_() == null || this.parent.m_58904_().f_46443_) {
            return;
        }
        this.parent.m_58904_().m_7260_(this.parent.m_58899_(), this.parent.m_58900_(), this.parent.m_58900_(), 3);
    }

    private void validateSlot(int slot) {
        if (slot < 0 || slot >= this.items.size() + 1) {
            throw new IllegalStateException(TextUtils.f("Slot {} is not in range [0,{})", slot, this.items.size()));
        }
    }

    private int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public int getSlots() {
        return this.items.size() + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        if (slot == this.items.size()) {
            return this.catalyst;
        }
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.f_41583_;
        }
        return this.parent.handleInteraction(null, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public AltarInvWrapper getVanillaInv() {
        return this.vanillaInv;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public void setCatalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        this.onContentsChanged();
    }
}

